import { Fragment } from "react";

import type { CSSProperties, FC } from "react";

const BannerProductionNotice: FC<{
    isPro: boolean;
    isLicensed: boolean;
    isDevLicense: boolean;
    i18n: {
        noLicense: string;
        devLicense: string;
        devLicenseLearnMore: string;
        devLicenseLink: string;
    };
}> = ({ isPro, isLicensed, isDevLicense, i18n: { noLicense, devLicense, devLicenseLearnMore, devLicenseLink } }) => {
    if (!isPro) {
        return null;
    }

    const style: CSSProperties = { fontSize: 13, color: "#c95252", fontWeight: "bold", order: 9 };

    let useText = "";
    if (isDevLicense) {
        useText = devLicense;
    } else if (!isLicensed) {
        useText = noLicense;
    }

    return useText ? (
        <div style={style}>
            {useText}
            {isDevLicense && (
                <Fragment>
                    {" ("}
                    <a href={devLicenseLink} rel="noreferrer" target="_blank" style={style}>
                        {devLicenseLearnMore}
                    </a>
                    {")"}
                </Fragment>
            )}
        </div>
    ) : null;
};

export { BannerProductionNotice };
