import { observer } from "mobx-react";
import { Outlet } from "react-router-dom";

import { BlockerNoticeNotActive } from "./noticeBlockerNotActive.js";
import { ConfigHintModal } from "../hintModal.js";

import type { FC } from "react";

const BlockerLayout: FC = observer(() => {
    return (
        <>
            <BlockerNoticeNotActive style={{ margin: "10px 0 0 0" }} />
            <Outlet />
            <ConfigHintModal identifier="blocker" />
        </>
    );
});

export { BlockerLayout };
