import { observer } from "mobx-react";

import { useStores } from "../../../store/stores.js";
import { __ } from "../../../utils/i18n.js";

import type { CSSProperties, FC } from "react";

const BlockerNoticeNotActive: FC<{ style?: CSSProperties }> = observer(({ style }) => {
    const {
        optionStore: { isBlockerActive, allBlockerCount },
    } = useStores();

    return (
        !isBlockerActive &&
        allBlockerCount > 0 && (
            <div className="notice notice-warning inline below-h2 notice-alt" style={style}>
                <p>
                    {__(
                        "Content Blockers are globally deactivated in the settings and are therefore not displayed on your website.",
                    )}{" "}
                    &bull; <a href="#/settings">{__("Enable now")}</a>
                </p>
            </div>
        )
    );
});

export { BlockerNoticeNotActive };
