import { App, Divider } from "antd";
import { observer } from "mobx-react";

import { copyToClipboard } from "@devowl-wp/react-utils";

import { __ } from "../../../../utils/i18n.js";

import type { Consent } from "../../../../models/consent.js";
import type { FC } from "react";

const ConsentTableRecordExport: FC<{ record: Consent }> = observer(({ record }) => {
    const { message } = App.useApp();
    return (
        <>
            <Divider>{__("Export consent")}</Divider>
            <p className="description">
                {__("Use the button below to export all consents in a machine readable form.")}
            </p>
            <button
                className="button button-large"
                onClick={() => {
                    copyToClipboard(JSON.stringify(record.export));
                    message.success(__("Successfully copied to the clipboard!"));
                }}
            >
                {__("Export to clipboard")}
            </button>
        </>
    );
});

export { ConsentTableRecordExport };
