import { Col, Divider, Empty, Row, Select } from "antd";
import { observer } from "mobx-react";
import { useState } from "react";

import { UpsellModal } from "@devowl-wp/react-cookie-banner-admin";

import { StatsButtonClickedPieChart } from "./buttonClickedPie.js";
import { StatsCustomBypassPieChart } from "./customBypassPie.js";
import { StatsMainBarChart } from "./mainBar.js";
import { useAvailableDateRangesForFilter } from "../../../../hooks/useAvailableDateRangesForFilter.js";
import { useStores } from "../../../../store/stores.js";
import { __ } from "../../../../utils/i18n.js";
import { DateRangePicker } from "../../../dateRangePicker.js";

import type { FC } from "react";

const StatsGrid: FC = observer(() => {
    const {
        optionStore: {
            others: { isPro, assetsUrl },
            contexts,
        },
        statsStore,
    } = useStores();
    const {
        filters: { dates, context },
    } = statsStore;
    const contextKeys = Object.keys(contexts);
    const [statsLiteInContainerRef, setStatsLiteInContainerRef] = useState<HTMLDivElement>();

    // Provide predefined ranges to the user
    const availableRanges = useAvailableDateRangesForFilter();

    return isPro ? (
        <>
            <div style={{ textAlign: "right" }}>
                {contextKeys.length > 1 && (
                    <>
                        <label>
                            <Select
                                style={{ width: 200, textAlign: "left" }}
                                value={context}
                                onSelect={(e) => statsStore.applyContext(e)}
                            >
                                {contextKeys.map((context) => (
                                    <Select.Option value={context} key={context}>
                                        {contexts[context]}
                                    </Select.Option>
                                ))}
                            </Select>
                        </label>
                        <Divider type="vertical" />
                    </>
                )}
                <label>
                    {__("Period")}:{" "}
                    <DateRangePicker
                        value={
                            /* Ant design relies on moment 2.27 and typings are currently incompatible with other moment typings */ dates as any
                        }
                        ranges={availableRanges as any}
                        onChange={(dates) => statsStore.applyDates(dates as any)}
                    />
                </label>
            </div>
            {dates?.length === 2 ? (
                <>
                    <Row>
                        <Col md={12} sm={24}>
                            <Divider>{__("Consents by clicked button")}</Divider>
                            <StatsButtonClickedPieChart />
                        </Col>
                        <Col md={12} sm={24}>
                            <Divider>{__("Cookie banner bypass")}</Divider>
                            <StatsCustomBypassPieChart />
                        </Col>
                    </Row>
                    <Row>
                        <Col
                            md={20}
                            sm={24}
                            style={{
                                margin: "auto",
                                paddingTop: 20,
                                marginTop: 30,
                            }}
                        >
                            <Divider>{__("Consents by group")}</Divider>
                            <StatsMainBarChart />
                        </Col>
                    </Row>
                </>
            ) : (
                <Empty description={__("Please provide a date range!")} />
            )}
        </>
    ) : (
        <>
            <UpsellModal
                title={__("Want to see detailed statistics about the consents of your visitors?")}
                inContainer
                inContainerElement={statsLiteInContainerRef}
                testDrive
                feature="stats"
                description={__(
                    "You can get several statistics about how your users use the cookie banner. This helps you to calculate the total number of users who do not want to be tracked, for example, by extrapolating data from Google Analytics.",
                )}
            />
            <div
                ref={setStatsLiteInContainerRef}
                className="rcb-antd-modal-mount"
                style={{
                    height: 800,
                    backgroundImage: `url('${assetsUrl}statistics-blured.png')`,
                }}
            />
        </>
    );
});

export { StatsGrid };
