import { Tabs } from "antd";
import { observer } from "mobx-react";
import { useNavigate, useParams } from "react-router-dom";

import { ConsentTable } from "./list/table.js";
import { ShortcodeCards } from "./shortcode/cards.js";
import { StatsGrid } from "./stats/grid.js";
import { __ } from "../../../utils/i18n.js";
import { ConfigContent } from "../content.js";
import { ConfigHintModal } from "../hintModal.js";

import type { FC } from "react";

const ConsentTabRouter: FC = observer(() => {
    const tab = useParams().tab || "";
    const navigate = useNavigate();

    return (
        <Tabs
            defaultActiveKey={tab}
            onChange={(key) => {
                navigate(`/consent/${key}`);
            }}
            items={[
                {
                    key: "",
                    label: __("Statistics"),
                    children: (
                        <ConfigContent maxWidth="fixed" style={{ paddingTop: 0 }}>
                            <StatsGrid />
                        </ConfigContent>
                    ),
                },
                {
                    key: "list",
                    label: __("List of consents"),
                    children: (
                        <>
                            <ConsentTable />
                            <ConfigHintModal identifier="list-of-consents" />
                        </>
                    ),
                },
                {
                    key: "legal",
                    label: __("Legal links"),
                    children: (
                        <>
                            <ShortcodeCards />
                            <ConfigHintModal identifier="shortcodes" />
                        </>
                    ),
                },
            ]}
        />
    );
});

export { ConsentTabRouter };
