import type { CSSProperties, FC, PropsWithChildren } from "react";

const ConfigContent: FC<
    PropsWithChildren<{ maxWidth?: CSSProperties["maxWidth"] | "fixed"; style?: CSSProperties }>
> = ({ children, maxWidth = "auto", style = {} }) => {
    return (
        <div className="rcb-config-content" style={{ maxWidth: maxWidth === "fixed" ? 1300 : maxWidth, ...style }}>
            {children}
        </div>
    );
};

export { ConfigContent };
