import { Spin } from "antd";
import { observer } from "mobx-react";
import { useEffect } from "react";
import { Outlet } from "react-router-dom";

import { useStores } from "../../../../store/stores.js";
import { ConfigHintModal } from "../../hintModal.js";

import type { FC } from "react";

const TcfLayout: FC = observer(() => {
    const { tcfStore } = useStores();
    const { purposes } = tcfStore;

    // Load all declarations
    useEffect(() => {
        tcfStore.fetchDeclarations();
    }, []);

    return purposes.size === 0 ? (
        <Spin style={{ margin: "auto", marginTop: 15 }} />
    ) : (
        <>
            <Outlet />
            <ConfigHintModal identifier="tcf-vendor" />
        </>
    );
});

export { TcfLayout };
