import { App } from "antd";
import { runInAction } from "mobx";
import { observer } from "mobx-react";
import { useEffect, useState } from "react";
import { useNavigate } from "react-router-dom";

import { ListTcfVendor, useListTcfVendorProvider } from "@devowl-wp/react-cookie-banner-admin";

import { TcfVendorConfigurationForm } from "./form.js";
import { useLocationQuery } from "../../../../hooks/useLocationQuery.js";
import { useRouteTcfVendorConfiguration } from "../../../../hooks/useRouteTcfVendorConfiguration.js";
import { TcfVendorConfigurationModel } from "../../../../models/tcfVendorConfigurationModel.js";
import { useStores } from "../../../../store/stores.js";
import { __ } from "../../../../utils/i18n.js";
import { ConfigContent } from "../../content.js";

import type { TcfVendor } from "../../../../models/tcfVendor.js";
import type { FC } from "react";

// TODO [TCF] where could we configure this? in the service cloud?
function useTcfVendorAdNetworks() {
    return [
        {
            identifier: "google-adsense",
            name: "Google AdSense",
            description: __(
                "%s displays advertisements from various advertising partners (ad servers) on your website by integrating just one script. A complex bidding system decides which advertising partner receives the advertising slot in the end.",
                "Google AdSense",
            ),
            provider: "Google",
            logo: "https://assets.devowl.io/in-app/wp-real-cookie-banner/logos/google-a-dsense.svg",
            hasRealTimeApi: false,
            updatedAt: "2025-01-10T14:31:24.791Z",
            createContentBlockerForVendorId: 755,
            onCreateOrEditContentBlocker: () => {
                // TODO [TCF] this should be more generic
                window.location.href = `#/blocker/new?force=google-adsense-tcf&navigateAfterCreation=${encodeURIComponent(
                    `#/cookies/tcf-vendors`,
                )}`;
            },
            lists: [
                {
                    name: __("Google Advertising Products only"),
                    description: __(
                        "Only Google can display ads booked e.g. via Google Ads. This means that you obtain less consent from your website visitors, but will not generate the optimum revenue.",
                    ),
                    vendorIds: [755],
                },
                {
                    name: __("Commonly used ad partners"),
                    description: __(
                        "Consent is requested for all advertising partners who display a particularly large amount of advertising via Adsense (list provided by Google). This increases your revenue and at the same time you obtain consent from a manageable number of TCF vendors.",
                    ),
                    vendorIds:
                        "1,10,11,12,13,14,15,16,21,23,24,25,27,28,32,36,37,39,40,45,50,52,57,59,63,69,70,73,76,77,78,80,81,82,85,91,93,97,98,104,109,110,119,124,126,128,129,130,142,148,156,157,161,163,164,173,174,192,193,202,209,210,231,232,238,241,246,253,264,273,275,278,281,284,290,294,295,297,304,312,315,326,328,333,345,351,373,375,384,387,394,413,415,423,431,450,452,469,486,488,490,508,527,528,541,550,559,565,572,587,612,620,631,663,667,686,690,699,728,740,755,758,767,793,804,807,867,874,976,1002,1005,1019,1020,1067,1071,1126,1135,1142,1271,1342,1386"
                            .split(",")
                            .map(Number),
                    isRecommended: true,
                },
                {
                    name: __("All ad partners using %s", "Google Adsense"),
                    description: __(
                        "Consent is obtained for all advertising partners who display advertising via %s. This leads to maximum revenue, but data protectionists could question the effectiveness of the consent due to the excessive number of vendors.",
                        "Google Adsense",
                    ),
                    vendorIds:
                        "1,2,4,6,10,11,12,13,14,15,16,20,21,23,24,25,26,27,28,29,30,31,32,33,34,36,37,39,40,42,44,45,46,47,50,52,53,55,56,57,58,59,60,61,62,63,66,67,69,70,72,73,75,76,77,78,80,81,82,83,84,85,87,90,91,92,93,94,95,97,98,100,101,104,108,109,110,111,114,115,119,120,124,126,127,128,129,130,131,132,133,134,136,137,138,139,140,141,142,143,148,149,151,153,154,155,156,157,159,160,161,163,164,168,173,174,178,184,185,192,193,195,196,199,202,203,205,206,209,210,212,213,215,216,217,224,226,227,228,231,232,235,237,238,239,241,242,243,244,246,248,249,251,252,253,254,255,256,259,262,263,264,270,272,273,274,275,276,278,279,280,281,282,284,285,290,293,294,295,297,298,301,302,304,308,311,312,315,316,318,319,321,323,325,326,328,329,331,333,336,337,343,345,347,350,351,354,358,361,371,373,374,375,377,378,380,381,382,384,387,388,394,397,402,409,410,412,413,415,416,418,422,423,424,427,430,431,435,436,438,440,444,448,450,452,454,459,461,466,469,471,475,479,486,488,490,491,493,495,496,497,498,501,502,507,508,509,511,512,516,517,519,524,527,528,531,534,536,539,541,546,549,550,551,553,554,556,559,561,565,568,569,570,571,572,573,580,581,584,587,591,596,597,598,601,602,606,610,612,613,617,618,620,621,625,626,628,630,631,639,644,646,647,648,652,653,655,656,657,658,659,662,663,665,666,667,671,673,676,677,681,682,684,685,686,687,690,699,702,703,706,707,708,709,712,713,715,716,717,718,719,721,723,724,725,726,727,728,729,730,731,732,733,734,736,737,738,740,742,744,745,746,748,749,750,751,752,754,755,758,759,762,765,766,767,768,769,770,771,775,776,778,779,780,781,783,784,786,787,788,790,791,793,795,796,797,798,799,800,801,803,804,806,807,810,811,812,814,815,816,819,820,821,822,825,827,828,831,833,834,835,837,838,839,844,845,848,849,850,851,853,854,855,856,857,858,860,861,862,864,865,867,869,870,871,872,874,875,876,877,878,879,880,881,882,883,884,885,888,891,893,894,896,898,900,902,903,907,910,911,915,918,919,920,922,925,927,930,931,936,937,938,939,941,943,944,946,950,951,952,954,955,956,957,958,959,961,962,963,964,965,966,967,968,972,973,975,976,982,985,987,990,993,994,995,996,997,998,999,1001,1002,1003,1004,1005,1006,1009,1014,1016,1019,1020,1021,1022,1024,1025,1026,1027,1028,1029,1030,1031,1032,1036,1037,1038,1039,1040,1041,1043,1044,1045,1046,1047,1048,1049,1050,1051,1055,1057,1058,1059,1060,1061,1062,1063,1067,1068,1069,1070,1071,1072,1075,1076,1078,1079,1080,1081,1083,1084,1085,1087,1090,1094,1097,1098,1100,1101,1103,1104,1105,1106,1107,1110,1111,1112,1113,1116,1119,1121,1122,1124,1126,1127,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1141,1142,1144,1148,1149,1151,1153,1154,1155,1156,1157,1159,1160,1162,1163,1164,1165,1167,1169,1170,1172,1173,1174,1175,1176,1177,1178,1180,1181,1182,1183,1184,1185,1187,1188,1189,1193,1195,1196,1197,1198,1199,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1212,1213,1214,1216,1217,1219,1222,1223,1225,1226,1227,1228,1229,1230,1234,1235,1236,1237,1238,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1251,1252,1253,1254,1257,1260,1261,1262,1263,1264,1266,1267,1268,1269,1270,1271,1272,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1305,1306,1307,1308,1310,1311,1312,1313,1314,1315,1316,1317,1318,1320,1321,1322,1323,1325,1326,1327,1329,1330,1332,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1400,1401,1402,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490"
                            .split(",")
                            .map(Number),
                },
            ],
        },
        {
            identifier: "the-moneytizer",
            name: "The Moneytizer",
            description: __(
                "%s displays advertisements from various advertising partners (ad servers) on your website by integrating just one script. A complex bidding system decides which advertising partner receives the advertising slot in the end.",
                "The Moneytizer",
            ),
            provider: "The Moneytizer",
            logo: "https://assets.devowl.io/in-app/wp-real-cookie-banner/logos/the-moneyt-izer.png",
            hasRealTimeApi: false,
            updatedAt: "2025-01-21T14:31:24.791Z",
            createContentBlockerForVendorId: 1265,
            onCreateOrEditContentBlocker: () => {
                // TODO [TCF] this should be more generic
                window.location.href = `#/blocker/new?force=the-moneytizer-tcf&navigateAfterCreation=${encodeURIComponent(
                    `#/cookies/tcf-vendors`,
                )}`;
            },
            lists: [
                {
                    name: __("All ad partners using %s", "The Moneytizer"),
                    description: __(
                        "Consent is obtained for all advertising partners who display advertising via %s. This leads to maximum revenue, but data protectionists could question the effectiveness of the consent due to the excessive number of vendors.",
                        "The Moneytizer",
                    ),
                    vendorIds:
                        "2,10,11,12,13,16,21,24,25,28,31,32,36,39,40,42,45,50,52,58,61,62,68,69,71,72,73,76,80,81,87,90,91,95,97,108,111,114,128,129,131,132,138,142,148,156,157,161,164,210,231,238,241,244,253,254,259,264,276,284,285,301,316,358,380,382,410,423,436,469,511,561,565,602,606,610,617,639,655,666,687,724,737,755,776,779,780,781,793,799,816,918,937,990,1028,1043,1083,1111,1132,1134,1135,1148,1165,1288,1408"
                            .split(",")
                            .map(Number),
                },
            ],
        },
    ];
}

const TcfVendorSelector: FC = observer(() => {
    const { message } = App.useApp();
    const { tcfStore, optionStore } = useStores();
    const { busyVendors, fetchedAllVendorConfigurations, vendorConfigurations, vendors } = tcfStore;
    const [vendor, setVendor] = useState<TcfVendor>();
    const { link } = useRouteTcfVendorConfiguration();
    const { adNetwork: defaultCreateAdNetworkIdentifier } = useLocationQuery();
    const adNetworks = useTcfVendorAdNetworks();
    const navigate = useNavigate();

    useEffect(() => {
        // Load all my configurations so we can show a "Already created"
        if (!tcfStore.fetchedAllVendorConfigurations) {
            tcfStore.fetchVendorConfigurations();
        }

        tcfStore.fetchVendors();
    }, []);

    const [ListTcfVendorContextProvider, listTcfVendorContextValue] = useListTcfVendorProvider(
        {
            busy: busyVendors || vendors.size === 0 || !fetchedAllVendorConfigurations,
            vendorCount: vendors.size,
            rows: Array.from(vendors.values()).map((vendor) => {
                const { vendorConfiguration } = vendor;
                return {
                    busy: false,
                    configuration: !!vendorConfiguration,
                    vendor: vendor.data,
                    blocker: vendorConfiguration ? vendorConfiguration.data.blocker : false,
                };
            }),
            view: "vendors",
            defaultCreateAdNetworkIdentifier,
            adNetworks,
            onCreate: ({ id }) => setVendor(vendors.get(id.toString())),
            onBulkCreate: async (vendors, onQueueItemFinished, signal, bulkDone) => {
                // Each TCF vendor deletion leads to fetching the current revision, suspend
                // this to avoid thousands of requests and do this after all vendors got deleted.
                const drafts: TcfVendorConfigurationModel[] = [];
                const promises: Promise<any>[] = []; // we need to wait for `fromResponse` call in `persist` method
                for (const { id } of vendors) {
                    const draft = new TcfVendorConfigurationModel(vendorConfigurations, {
                        status: "publish",
                        meta: {
                            dataProcessingInCountries: "[]",
                            dataProcessingInCountriesSpecialTreatments: "[]",
                            restrictivePurposes: "[]",
                            vendorId: id,
                        },
                    });
                    drafts.push(draft);

                    promises.push(
                        draft
                            .persist(undefined, {
                                allowBatchRequest: {
                                    onQueueItemFinished,
                                    waitForPromise: bulkDone,
                                },
                                settings: { signal },
                            })
                            .catch((e) => message.error(e.responseJSON.message)),
                    );
                }

                await Promise.allSettled(promises);
                runInAction(() => {
                    for (const d of drafts) {
                        if (d.key) {
                            d.collection.entries.set(d.key, d);
                        }
                    }
                });
                await optionStore.fetchCurrentRevision();

                setTimeout(() => navigate(link.slice(1)), 0);
            },
        },
        {},
        {
            inherit: ["busy", "vendorCount", "rows"],
        },
    );

    return vendor === undefined ? (
        <ConfigContent>
            <ListTcfVendorContextProvider value={listTcfVendorContextValue}>
                <ListTcfVendor />
            </ListTcfVendorContextProvider>
        </ConfigContent>
    ) : (
        <ConfigContent maxWidth="fixed">
            <TcfVendorConfigurationForm vendor={vendor} />
        </ConfigContent>
    );
});

export { TcfVendorSelector, useTcfVendorAdNetworks };
