import { Badge } from "antd";
import { observer } from "mobx-react";

import { useStores } from "../../../store/stores.js";
import { __, _i } from "../../../utils/i18n.js";

import type { FC } from "react";

const DashboardCacheCardContent: FC = observer(() => {
    const {
        optionStore: {
            others: { cachePlugins },
        },
    } = useStores();

    const cachePluginLabels = Object.values(cachePlugins).join(", ");

    return (
        <>
            <p className="description">
                {__(
                    "Real Cookie Banner can empty your page cache automatically as soon as a page cache is detected. This means that you do not have to manually clear your page cache if you make changes to the cookie banner via the customizer or if you ask for a new consent.",
                )}
            </p>
            {cachePluginLabels ? (
                <Badge
                    status="success"
                    text={_i(__("We have detected {{strong}}%s{{/strong}} as your page cache.", cachePluginLabels), {
                        strong: <strong />,
                    })}
                />
            ) : (
                <Badge
                    status="default"
                    text={_i(__("We did {{strong}}not detect{{/strong}} any page cache on your site."), {
                        strong: <strong />,
                    })}
                />
            )}
        </>
    );
});

export { DashboardCacheCardContent };
