import { CheckCircleFilled, CheckCircleOutlined, InfoCircleFilled } from "@ant-design/icons";
import { Tag, Tooltip } from "antd";
import { observer } from "mobx-react";

import {
    IN_APP_FOMO_URL_PARAMETER_TO_DEACTIVATE_WEBSITE_FOMO,
    UPSELL_TAG_BACKGROUND_COLOR,
    UpsellInAppFomoCouponCounter,
} from "@devowl-wp/react-cookie-banner-admin";

import { useScannerProgress } from "../../../hooks/useScannerProgress.js";
import { useStores } from "../../../store/stores.js";
import { __ } from "../../../utils/i18n.js";

import type { ResponseRouteChecklistGetEntity } from "../../../wp-api/checklist.get.js";
import type { DOMAttributes, FC } from "react";

const DashboardChecklistItem: FC<
    ResponseRouteChecklistGetEntity & {
        id?: string;
        onLinkClick?: DOMAttributes<HTMLAnchorElement>["onClick"];
    }
> = observer(({ id, checked, title, description, link, linkText, linkTarget, needsPro, onLinkClick }) => {
    const {
        optionStore: {
            others: { isPro },
            fomoCoupon,
        },
    } = useStores();
    const isInfo = !isPro && needsPro;

    let extraContentTag: any = null;
    let extraContentDescription: any = null;
    let useLink = link;

    switch (id) {
        case "scanner": {
            const { percent: scanPercent, remaining: scanRemaining, currentJob } = useScannerProgress();
            if (scanRemaining > 0 && scanPercent > 0 && currentJob?.group_position > 0) {
                extraContentTag = <Tag>{__("Currently scanning (%d %%)", scanPercent)}</Tag>;
            }
            break;
        }
        case "get-pro": {
            extraContentDescription = <UpsellInAppFomoCouponCounter />;

            if (fomoCoupon) {
                useLink += `&${IN_APP_FOMO_URL_PARAMETER_TO_DEACTIVATE_WEBSITE_FOMO}`;
            }
            break;
        }
        default:
            break;
    }

    return (
        <div style={{ margin: "5px 0" }}>
            <Tooltip title={checked && description}>
                <span>
                    {isInfo ? (
                        <InfoCircleFilled style={{ color: "#7ec8ec" }} />
                    ) : checked ? (
                        <CheckCircleFilled style={{ color: "#52c41a" }} />
                    ) : (
                        <CheckCircleOutlined style={{ color: "#e2e2e2" }} />
                    )}{" "}
                    <span style={{ textDecoration: checked ? "line-through" : undefined, fontWeight: "bold" }}>
                        {title}
                    </span>
                    {!!useLink && !!linkText && (
                        <>
                            &nbsp;&nbsp;&bull;&nbsp;&nbsp;
                            <a href={useLink} target={linkTarget} rel="noreferrer" onClick={onLinkClick}>
                                {linkText}
                            </a>
                        </>
                    )}
                </span>
            </Tooltip>
            {isInfo && id !== "get-pro" && (
                <>
                    &nbsp;<Tag color={UPSELL_TAG_BACKGROUND_COLOR}>{__("Needs PRO")}</Tag>
                </>
            )}
            {!!extraContentTag && <>&nbsp;{extraContentTag}</>}
            {!!description && !checked && (
                <p className="description" style={{ paddingLeft: 17 }}>
                    {description}
                </p>
            )}
            {!!extraContentDescription && <div style={{ paddingLeft: 17 }}>{extraContentDescription}</div>}
        </div>
    );
});

export { DashboardChecklistItem };
