import { Badge, Spin, Tag } from "antd";
import { observer } from "mobx-react";

import { useStores } from "../../../store/stores.js";
import { __, _i } from "../../../utils/i18n.js";

import type { FC } from "react";

const HREF_SETTINGS = "#/settings";
const HREF_COOKIES = "#/cookies";
const HREF_TCF_VENDORS = "#/cookies/tcf-vendors";

const DashboardGeneralCardContent: FC = observer(() => {
    const {
        optionStore,
        cookieStore: { groups },
    } = useStores();
    const {
        isTcf,
        isBannerActive,
        isBlockerActive,
        busySettings,
        cookieCounts,
        isOnlyRcbCookieCreated,
        tcfVendorConfigurationCounts,
    } = optionStore;
    const useBlockerActive = isBannerActive && isBlockerActive;

    return (
        <Spin spinning={groups.busy || busySettings}>
            <div>
                <Badge
                    status={isBannerActive ? "success" : "error"}
                    text={_i(
                        isBannerActive
                            ? __("Cookie Banner is {{strong}}activated{{/strong}}")
                            : __("Cookie Banner is {{strong}}deactivated{{/strong}}"),
                        { strong: <strong /> },
                    )}
                />
                <p className="description">
                    {_i(__("You can enable and disable the cookie banner in the {{a}}settings page{{/a}}."), {
                        a: <a href={HREF_SETTINGS} />,
                    })}
                </p>
            </div>
            <div>
                <Badge
                    status={useBlockerActive ? "success" : "error"}
                    text={_i(
                        useBlockerActive
                            ? __("Content Blocker is {{strong}}activated{{/strong}}")
                            : __("Content Blocker is {{strong}}deactivated{{/strong}}"),
                        { strong: <strong /> },
                    )}
                />
                <p className="description">
                    {_i(__("You can enable and disable the content blocker in the {{a}}settings page{{/a}}."), {
                        a: <a href={HREF_SETTINGS} />,
                    })}
                </p>
            </div>
            <p>
                {__("Available service groups:")}{" "}
                {groups.sortedGroups.map(({ data: { name, id } }) => (
                    <Tag key={id}>{name}</Tag>
                ))}
                &bull;&nbsp;
                <a href={HREF_COOKIES}>{__("Manage")}</a>
            </p>
            <p>
                {_i(
                    __(
                        "You have defined {{strong}}%d enabled{{/strong}}, %d disabled and %d draft services.",
                        isOnlyRcbCookieCreated ? 0 : cookieCounts.publish,
                        isOnlyRcbCookieCreated ? 0 : cookieCounts.private,
                        isOnlyRcbCookieCreated ? 0 : cookieCounts.draft,
                    ),
                    { strong: <strong /> },
                )}
                &nbsp;&nbsp;&bull;&nbsp;&nbsp;
                <a href={HREF_COOKIES}>{__("Manage")}</a>
            </p>
            {isTcf && tcfVendorConfigurationCounts && (
                <p>
                    {_i(
                        __(
                            "You have defined {{strong}}%d enabled{{/strong}}, %d disabled and %d draft TCF vendors.",
                            tcfVendorConfigurationCounts.publish,
                            tcfVendorConfigurationCounts.draft,
                            tcfVendorConfigurationCounts.private,
                        ),
                        { strong: <strong /> },
                    )}
                    &nbsp;&nbsp;&bull;&nbsp;&nbsp;
                    <a href={HREF_TCF_VENDORS}>{__("Manage")}</a>
                </p>
            )}
        </Spin>
    );
});

export { DashboardGeneralCardContent };
