import { observer } from "mobx-react";

import type { OtherOptions } from "../../../types/otherOptions.js";
import type { FC } from "react";

const DashboardHintCardContent: FC<Omit<OtherOptions["hints"]["dashboardTile"][0], "title">> = observer(
    ({ description, links, logo }) => {
        return (
            <>
                {!!logo && (
                    <img
                        src={logo}
                        style={{ maxWidth: "100%", maxHeight: "80px", display: "block", margin: "0 0 10px" }}
                    />
                )}
                {!!description && <p className="description" dangerouslySetInnerHTML={{ __html: description }} />}
                {links?.map(({ link, linkText }) => (
                    <a
                        key={link}
                        href={link}
                        target="_blank"
                        rel="noreferrer"
                        className="button"
                        style={{ marginTop: 13, marginRight: 10 }}
                    >
                        {linkText}
                    </a>
                ))}
            </>
        );
    },
);

export { DashboardHintCardContent };
