import { HeartFilled } from "@ant-design/icons";
import { observer } from "mobx-react";

import { useStores } from "../../store/stores.js";
import { __, _i } from "../../utils/i18n.js";

import type { FC } from "react";

const ConfigFooter: FC = observer(() => {
    const {
        optionStore: { publicUrl },
    } = useStores();

    return (
        <div className="rcb-config-footer">
            {_i(__("Real Cookie Banner is brought to you with {{icon/}} by"), {
                icon: <HeartFilled style={{ color: "#dca7a7" }} />,
            })}
            <a href={__("https://devowl.io/")} target="_blank" rel="noreferrer">
                <img src={`${publicUrl}images/logos/devowl-with-text.svg`} />
            </a>
        </div>
    );
});

export { ConfigFooter };
