import { CheckCircleOutlined } from "@ant-design/icons";
import { Modal } from "antd";
import { observer } from "mobx-react";
import { useCallback, useEffect, useState } from "react";
import { useLocation } from "react-router-dom";

import { DashboardChecklistCardContent } from "./dashboard/checklist.js";
import { useStores } from "../../store/stores.js";
import { __ } from "../../utils/i18n.js";
import { ProHeadlineButton } from "../proHeadlineButton.js";

import type { DOMAttributes, FC } from "react";

const ConfigHeader: FC = observer(() => {
    const [isChecklistModalOpen, setChecklistModalOpen] = useState(false);
    const { optionStore, checklistStore } = useStores();
    const { pathname } = useLocation();
    const {
        others: { customizeBannerUrl },
        publicUrl,
    } = optionStore;
    const { completed, checkable, done } = checklistStore;

    useEffect(() => {
        checklistStore.fetchChecklist();
    }, []);

    const handleCustomizeBannerButtonClick: DOMAttributes<HTMLAnchorElement>["onClick"] = useCallback((e) => {
        window.location.href = `${customizeBannerUrl}&return=${encodeURIComponent(window.location.href)}`;
        e.preventDefault();
    }, []);

    const handleChecklistModalOpen = useCallback(() => {
        setChecklistModalOpen(true);
        checklistStore.fetchChecklist();
    }, [setChecklistModalOpen]);

    const handleChecklistModalClose = useCallback(() => {
        setChecklistModalOpen(false);
    }, [setChecklistModalOpen]);

    return (
        <>
            <h1 className="wp-heading-inline">{__("Real Cookie Banner")}</h1>
            <img className="rcb-nav-logo" src={`${publicUrl}images/logos/real-cookie-banner.svg`} />
            <a className="page-title-action" href="#" onClick={handleCustomizeBannerButtonClick}>
                {__("Customize banner")}
            </a>
            <ProHeadlineButton />
            {!done && pathname !== "/" && (
                <>
                    <a
                        className="page-title-action"
                        style={{ color: "#52c41a", background: "#f6ffed", borderColor: "#85af65" }}
                        onClick={handleChecklistModalOpen}
                    >
                        <CheckCircleOutlined />
                        &nbsp;
                        {__(
                            "%d / %d steps completed",
                            completed.length > checkable.length ? checkable.length : completed.length, // avoid overflow due infos
                            checkable.length,
                        )}
                    </a>
                    <Modal
                        open={isChecklistModalOpen}
                        title={__("Set up the cookie banner")}
                        onCancel={handleChecklistModalClose}
                        okButtonProps={{ style: { display: "none" } }}
                        cancelText={__("Close")}
                        width={800}
                    >
                        <DashboardChecklistCardContent showHidden onLinkClick={handleChecklistModalClose} />
                    </Modal>
                </>
            )}
            <hr className="wp-header-end"></hr>
        </>
    );
});

export { ConfigHeader };
