import { Card, Col, Row } from "antd";
import { observer } from "mobx-react";

import { ExportForm } from "./export.js";
import { ExportConsentsForm } from "./exportConsents.js";
import { ImportForm } from "./import.js";
import { useConfigHintText } from "../../../hooks/useConfigHintText.js";
import { __ } from "../../../utils/i18n.js";
import { ConfigHintModal } from "../hintModal.js";

import type { FC } from "react";

const ImportExportCards: FC = observer(() => {
    const hintText = useConfigHintText("import");

    return (
        <Row>
            <Col xl={16} sm={16} xs={24}>
                <Card style={{ margin: 10 }} title={__("Import")}>
                    <ImportForm />
                </Card>
            </Col>
            <Col xl={8} sm={8} xs={24}>
                <Card style={{ margin: 10 }} title={__("Export")}>
                    <ExportForm />
                </Card>
                <Card style={{ margin: 10 }} title={__("Export consents")}>
                    <ExportConsentsForm />
                </Card>
            </Col>
            <p className="description" style={{ maxWidth: 800, margin: "30px auto 0", textAlign: "center" }}>
                {hintText}
            </p>
            <ConfigHintModal identifier="import" />
        </Row>
    );
});

export { ImportExportCards };
