import { Divider } from "antd";
import { observer } from "mobx-react";
import { useCallback } from "react";

import { __ } from "../../../utils/i18n.js";

import type { ResponseRouteImportPost } from "../../../wp-api/import.post.js";
import type { FC } from "react";

const ImportFormResultMessage: FC<{ result: ResponseRouteImportPost }> = observer(({ result }) => {
    const generateFixLink = useCallback(
        ({
            fix,
            settingsTab,
            cookieDuplicate,
            cookie,
            blockerDuplicate,
            blocker,
            href,
            linkText,
        }: Partial<ResponseRouteImportPost["messages"][0]>) => {
            switch (fix) {
                case "settings":
                    return (
                        <a href={`#/settings/${settingsTab}`} target="_blank" rel="noreferrer">
                            {__("Set manually")}
                        </a>
                    );
                case "cookieDuplicate": {
                    const {
                        original: [originalGroupId, originalId],
                        duplicate: [duplicateGroupId, duplicateId],
                    } = cookieDuplicate;
                    return (
                        <>
                            <a
                                href={`#/cookies/${originalGroupId}/edit/${originalId}`}
                                target="_blank"
                                rel="noreferrer"
                            >
                                {__("Open original")}
                            </a>{" "}
                            &bull;{" "}
                            <a
                                href={`#/cookies/${duplicateGroupId}/edit/${duplicateId}`}
                                target="_blank"
                                rel="noreferrer"
                            >
                                {__("Open newly created")}
                            </a>
                        </>
                    );
                }
                case "cookie": {
                    const [group, id] = cookie;
                    return (
                        <a href={`#/cookies/${group}/edit/${id}`} target="_blank" rel="noreferrer">
                            {__("Check manually")}
                        </a>
                    );
                }
                case "blockerDuplicate": {
                    const { original, duplicate } = blockerDuplicate;
                    return (
                        <>
                            <a href={`#/blocker/edit/${original}`} target="_blank" rel="noreferrer">
                                {__("Open original")}
                            </a>{" "}
                            &bull;{" "}
                            <a href={`#/blocker/edit/${duplicate}`} target="_blank" rel="noreferrer">
                                {__("Open newly created")}
                            </a>
                        </>
                    );
                }
                case "blocker": {
                    return (
                        <a href={`#/blocker/edit/${blocker}`} target="_blank" rel="noreferrer">
                            {__("Check manually")}
                        </a>
                    );
                }
                case "link": {
                    return (
                        <a href={href} rel="noreferrer">
                            {linkText || __("Set manually")}
                        </a>
                    );
                }
                default:
                    return null;
            }
        },
        [],
    );

    if (!result) {
        return null;
    }

    return (
        <>
            <Divider style={{ marginTop: 0 }}>{__("Result")}</Divider>
            {result.messages.map(({ message, severity, ...fix }, i) => (
                <div
                    key={i}
                    className={`notice notice-${severity} inline below-h2 notice-alt`}
                    style={{ margin: "10px 0 0 0" }}
                >
                    <p>
                        <span dangerouslySetInnerHTML={{ __html: message }} />
                        {!!fix.fix && <> &bull; {generateFixLink(fix)}</>}
                    </p>
                </div>
            ))}
        </>
    );
});

export { ImportFormResultMessage };
