import { observer } from "mobx-react";

import { getOtherOptionsFromWindow } from "../../utils/getOtherOptionsFromWindow.js";
import { __, _i } from "../../utils/i18n.js";

import type { FC } from "react";

const NoticeAnonymousScriptNotWritable: FC = observer(() => {
    const { showNoticeAnonymousScriptNotWritable } = getOtherOptionsFromWindow();

    return (
        !!showNoticeAnonymousScriptNotWritable && (
            <div className="notice notice-warning inline below-h2 notice-alt" style={{ margin: "10px 0 0 0" }}>
                <p>
                    {_i(__("Your {{code}}wp-content{{/code}} folder is not writable. Please check your permissions!"), {
                        code: <code />,
                    })}
                </p>
            </div>
        )
    );
});

export { NoticeAnonymousScriptNotWritable };
