import { observer } from "mobx-react";

import { useStores } from "../../store/stores.js";
import { __ } from "../../utils/i18n.js";

import type { FC } from "react";

const NoticeBannerActiveNoCookies: FC = observer(() => {
    const {
        optionStore: { publicCookieCount, busySettings, isBannerActive },
    } = useStores();

    return (
        isBannerActive &&
        !publicCookieCount &&
        !busySettings && (
            <div className="notice notice-warning inline below-h2 notice-alt" style={{ margin: "10px 0 0 0" }}>
                <p>
                    {__(
                        "The cookie banner is activated, but unfortunately you have not yet created or enabled services.",
                    )}
                </p>
            </div>
        )
    );
});

export { NoticeBannerActiveNoCookies };
