import { observer } from "mobx-react";
import { useLocation } from "react-router-dom";

import { getManagerDependingVariables } from "@devowl-wp/cookie-consent-web-client";

import { useStores } from "../../store/stores.js";
import { __, _i } from "../../utils/i18n.js";

import type { FC } from "react";

const NoticeNoManager: FC = observer(() => {
    const {
        optionStore: { setCookiesViaManager, createdTagManagers, isGcm },
    } = useStores();
    const { managerLabel, expectedManagerPresetId } = getManagerDependingVariables(setCookiesViaManager, {
        isGcm,
        presetId: "",
    });
    const { pathname } = useLocation();

    return (
        managerLabel &&
        !createdTagManagers[expectedManagerPresetId].length &&
        /^\/cookies\/\d+$/.test(pathname) && (
            <div className="notice notice-warning inline below-h2 notice-alt" style={{ margin: "10px 0 0 0" }}>
                <p>
                    {_i(
                        __(
                            "You have not yet defined a %s service. To use {{strong}}%s{{/strong}} with Real Cookie Banner, you must create the appropriate service.",
                            managerLabel,
                            managerLabel,
                        ),
                        { strong: <strong /> },
                    )}{" "}
                    &bull; <a href={`#${pathname}/new?force=${expectedManagerPresetId}`}>{__("Create now")}</a>
                </p>
            </div>
        )
    );
});

export { NoticeNoManager };
