import { Popconfirm } from "antd";
import { observer } from "mobx-react";
import { useLocation } from "react-router-dom";

import { useStores } from "../../store/stores.js";
import { __, _i } from "../../utils/i18n.js";

import type { FC } from "react";

const NoticeRevisionNeedsRetrigger: FC = observer(() => {
    const { optionStore } = useStores();
    const { pathname } = useLocation();

    return (
        optionStore.needsRevisionRetrigger &&
        pathname.indexOf("/edit/") === -1 &&
        pathname.indexOf("/new") === -1 && (
            <div className="notice notice-warning inline below-h2 notice-alt" style={{ margin: "10px 0 0 0" }}>
                <p>
                    {__(
                        "You have changed settings that affect the content or behavior of the cookie banner. You should ask all visitors for their consent again.",
                    )}{" "}
                    &bull;{" "}
                    <a
                        onClick={() =>
                            optionStore.updateCurrentRevision({
                                needs_retrigger: true,
                            })
                        }
                    >
                        {__("Request new consent")}
                    </a>{" "}
                    &bull;{" "}
                    <Popconfirm
                        title={
                            <>
                                <strong>{__("Are you sure you don't want to collect new consents?")}</strong>
                                <br />
                                <br />
                                {_i(
                                    __(
                                        "Consent must be obtained in accordance with {{a}}Art. 7 GDPR{{/a}}. Your visitor must be informed about all circumstances of the consent. However, you have made changes to your cookie banner, which lead to the fact that previously visitors have consented differently or to something different than is now in the cookie banner. Therefore, previously collected consents may have become partially invalid.",
                                    ),
                                    {
                                        a: (
                                            <a
                                                href={__("https://gdpr-text.com/read/article-7/")}
                                                rel="noreferrer"
                                                target="_blank"
                                            />
                                        ),
                                    },
                                )}
                                <br />
                                <br />
                                {__(
                                    "If you have created a new service like Google Analytics (without visual content blocker), previous visitors can never consent without collecting new consents and you cannot track them, for example.",
                                )}
                            </>
                        }
                        placement="bottomRight"
                        onConfirm={() =>
                            optionStore.updateCurrentRevision({
                                needs_retrigger: false,
                            })
                        }
                        okText={__("Dismiss notice")}
                        cancelText={__("Cancel")}
                        overlayStyle={{ maxWidth: 450 }}
                    >
                        <a>{__("Dismiss notice")}</a>
                    </Popconfirm>
                </p>
            </div>
        )
    );
});

export { NoticeRevisionNeedsRetrigger };
