import { observer } from "mobx-react";
import { useLocation } from "react-router-dom";

import { useStores } from "../../store/stores.js";
import { __ } from "../../utils/i18n.js";

import type { FC } from "react";

const NoticeServiceDataProcessingInUnsafeCountries: FC = observer(() => {
    const { optionStore } = useStores();
    const { pathname } = useLocation();
    const { servicesDataProcessingInUnsafeCountriesNoticeHtml } = optionStore;

    return (
        servicesDataProcessingInUnsafeCountriesNoticeHtml &&
        pathname.indexOf("/edit/") === -1 &&
        pathname.indexOf("/new") === -1 && (
            <div className="notice notice-warning inline below-h2 notice-alt" style={{ margin: "10px 0 0 0" }}>
                <span dangerouslySetInnerHTML={{ __html: servicesDataProcessingInUnsafeCountriesNoticeHtml }} />{" "}
                <p>
                    <a href="#/settings/consent">{__("Enable consent to data processing in unsafe third countries")}</a>{" "}
                    &bull;{" "}
                    <a onClick={() => optionStore.dismissServiceDataProcessingInUnsafeCountriesNotice()}>
                        {__("Dismiss notice")}
                    </a>
                </p>
            </div>
        )
    );
});

export { NoticeServiceDataProcessingInUnsafeCountries };
