import { Divider, List } from "antd";
import { observer } from "mobx-react";
import { useEffect } from "react";

import { ScannerListItem } from "./listItem.js";
import { ScannerLoadingSkeleton } from "./loadingSkeleton.js";
import { ScannerProgress } from "./progress.js";
import { ScannerTemplateCards } from "./templateCards.js";
import { useConfigHintText } from "../../../hooks/useConfigHintText.js";
import { useScannerProgress } from "../../../hooks/useScannerProgress.js";
import { useStores } from "../../../store/stores.js";
import { __ } from "../../../utils/i18n.js";
import { BlockerNoticeNotActive } from "../blocker/noticeBlockerNotActive.js";
import { ConfigContent } from "../content.js";
import { ConfigHintModal } from "../hintModal.js";

import type { FC } from "react";

const ScannerList: FC = observer(() => {
    const { scannerStore, cookieStore } = useStores();
    const { currentJob } = useScannerProgress();
    const { templatesCount, externalUrlsCount, busyExternalUrls, sortedExternalUrls, canShowResults } = scannerStore;
    const hintText = useConfigHintText("scanner");

    useEffect(() => {
        scannerStore.fetchResultTemplates();
        scannerStore.fetchResultExternals();
        cookieStore.fetchGroups();
    }, []);

    return (
        <>
            <BlockerNoticeNotActive style={{ margin: "10px 0 0 0" }} />
            <ConfigContent>
                <ScannerProgress />
                {canShowResults && templatesCount > 0 && <ScannerTemplateCards />}
                {canShowResults &&
                    externalUrlsCount > 0 &&
                    (busyExternalUrls && !sortedExternalUrls.length && currentJob === undefined ? (
                        <ScannerLoadingSkeleton count={externalUrlsCount} />
                    ) : (
                        <div>
                            <Divider>{__("Embeds of external URLs to be checked")}</Divider>
                            <div style={{ maxWidth: 800, margin: "0px auto 20px", textAlign: "center" }}>
                                <p className="description">
                                    {__(
                                        "You are embedding scripts, styles, iframes or similar from the following third-party servers. We currently do not have service templates for these. Therefore, you may have to create a service and/or content blocker yourself after you have assessed the situation.",
                                    )}
                                </p>
                            </div>
                            <List>
                                {sortedExternalUrls.map((item) => (
                                    <ScannerListItem item={item} key={item.data.host} />
                                ))}
                            </List>
                        </div>
                    ))}
                <div style={{ maxWidth: 800, margin: "30px auto 0", textAlign: "center" }}>{hintText}</div>
            </ConfigContent>
            <ConfigHintModal identifier="scanner" title={__("What does the scanner find?")} width={900} />
        </>
    );
});

export { ScannerList };
