import { List, Skeleton } from "antd";
import { useMemo } from "react";

import type { FC } from "react";

const ScannerLoadingSkeleton: FC<{ count: number }> = ({ count }) => {
    const dataSource = useMemo(() => {
        const d = [];
        for (let key = 0; key < count; key++) {
            d.push({ key });
        }
        return d;
    }, [count]);

    return (
        <List
            dataSource={dataSource}
            renderItem={() => (
                <List.Item>
                    <Skeleton loading={true} active avatar={false} paragraph={{ rows: 1 }} />
                </List.Item>
            )}
        />
    );
};

export { ScannerLoadingSkeleton };
