import { useI18nProvider, useUpsellProvider } from "@devowl-wp/react-cookie-banner-admin";

import { useStores } from "../../store/stores.js";
import { __, _i, _n, _x } from "../../utils/i18n.js";
import { Provider } from "../provider.js";

import type { FC, PropsWithChildren } from "react";

const RootStoreListener: FC<PropsWithChildren> = ({ children }) => {
    const {
        optionStore: {
            others: { isPro, isLicensed, hints, proUrl, isDemoEnv },
            fomoCoupon,
        },
    } = useStores();
    const [I18nContextProvider, i18nContextValue] = useI18nProvider({ __, _i, _n, _x });
    const [UpsellContextProvider, upsellContextValue] = useUpsellProvider(
        {
            isPro,
            isLicensed,
            isDemoEnv,
            hint: hints?.proDialog,
            proUrl,
            fomoCoupon,
        },
        {},
        {
            inherit: ["isLicensed", "fomoCoupon"],
        },
    );

    return (
        <I18nContextProvider value={i18nContextValue}>
            <UpsellContextProvider value={upsellContextValue}>{children}</UpsellContextProvider>
        </I18nContextProvider>
    );
};

/**
 * Provide multiple contexts so e.g. `@devowl-wp/react-cookie-banner-admin` can be used in customizer.
 */
const CustomizeContextProvider: FC<PropsWithChildren> = ({ children }) => {
    return (
        <Provider>
            <RootStoreListener>{children}</RootStoreListener>
        </Provider>
    );
};

export { CustomizeContextProvider };
