import { CUSTOM_CONTROL_INPUT_CHECKBOX_CLASS_NAME, useCustomControl } from "@devowl-wp/customize";
import { useUpsellModal } from "@devowl-wp/react-cookie-banner-admin";

import { __ } from "../../../utils/i18n.js";

import type { FC } from "react";

type GroupsFirstViewControlProps = Record<string, never>;

const GroupsFirstViewControl: FC = () => {
    const { value, setValue } = useCustomControl<boolean, GroupsFirstViewControlProps>();
    const { isPro, modal, tag } = useUpsellModal({
        title: __("Want to have a choice in the first view?"),
        testDrive: true,
        feature: "groups-first-view",
        assetName: __("pro-modal/groups-first-view.png"),
        description: __(
            "Visitors of your website can choose which service groups they want to accept immediately after loading the cookie banner, without the need to go into the individual privacy settings.",
        ),
    });

    return (
        <>
            {modal}
            <label>
                <input
                    className={CUSTOM_CONTROL_INPUT_CHECKBOX_CLASS_NAME}
                    type="checkbox"
                    disabled={!isPro}
                    value="1"
                    checked={isPro ? value : false}
                    onChange={() => setValue(!value)}
                />
                {__("Allow to choose service groups directly in the first view of the cookie banner")} {tag}
            </label>
        </>
    );
};

export { GroupsFirstViewControl };
