import { CUSTOM_CONTROL_INPUT_CHECKBOX_CLASS_NAME, useCustomControl } from "@devowl-wp/customize";
import { useUpsellModal } from "@devowl-wp/react-cookie-banner-admin";

import { __ } from "../../../utils/i18n.js";

import type { FC } from "react";

type StickyLinksControlProps = Record<string, never>;

function useProModalStickyLinks() {
    return useUpsellModal({
        title: __("Want to show legal links with a sticky icon?"),
        testDrive: true,
        feature: "sticky-links",
        assetName: __("pro-modal/sticky-legal-links.webm"),
        description: __(
            "Display a sticky icon on your website that makes the legal links easily accessible on every subpage. Not only does it look fancy, it also boosts your data protection!",
        ),
    });
}

const StickyLinksControl: FC = () => {
    const { value, setValue } = useCustomControl<boolean, StickyLinksControlProps>();
    const { isPro, modal, tag } = useProModalStickyLinks();

    return (
        <>
            {modal}
            <label>
                <input
                    className={CUSTOM_CONTROL_INPUT_CHECKBOX_CLASS_NAME}
                    type="checkbox"
                    disabled={!isPro}
                    value="1"
                    checked={isPro ? value : false}
                    onChange={() => setValue(!value)}
                />
                {__("Enable sticky links widget")} {tag}
            </label>
        </>
    );
};

export { StickyLinksControl, useProModalStickyLinks };
