import moment from "moment";

import { DatePicker } from "./momentDatePickerComponents.js";
import { __ } from "../utils/i18n.js";

import type { ComponentPropsWithRef, FC } from "react";

const { RangePicker } = DatePicker;

/**
 * A `RangePicker` depending on antd with localized WordPress settings.
 */
const DateRangePicker: FC<ComponentPropsWithRef<(typeof DatePicker)["RangePicker"]>> = (props) => {
    const localeData = moment.localeData();

    return (
        <RangePicker
            locale={{
                lang: {
                    locale: moment.locale(),
                    placeholder: __("Select date"),
                    rangePlaceholder: [__("Start date"), __("End date")],
                    today: __("Today"),
                    now: __("Now"),
                    backToToday: __("Back to today"),
                    ok: __("OK"),
                    clear: __("Clear"),
                    month: __("Month"),
                    year: __("Year"),
                    timeSelect: __("Select time"),
                    dateSelect: __("Select date"),
                    monthSelect: __("Choose a month"),
                    yearSelect: __("Choose a year"),
                    decadeSelect: __("Choose a decade"),
                    yearFormat: "YYYY",
                    dateFormat: localeData.longDateFormat("LL"),
                    dayFormat: "D",
                    dateTimeFormat: localeData.longDateFormat("LLL"), // "M/D/YYYY HH:mm:ss",
                    monthFormat: "MMMM",
                    monthBeforeYear: true,
                    previousMonth: __("Previous month (PageUp)"),
                    nextMonth: __("Next month (PageDown)"),
                    previousYear: __("Last year (Control + left)"),
                    nextYear: __("Next year (Control + right)"),
                    previousDecade: __("Last decade"),
                    nextDecade: __("Next decade"),
                    previousCentury: __("Last century"),
                    nextCentury: __("Next century"),
                },
                timePickerLocale: {
                    placeholder: __("Select time"),
                },
                dateFormat: localeData.longDateFormat("LL"),
                dateTimeFormat: localeData.longDateFormat("LLL"),
                weekFormat: "YYYY-wo",
                monthFormat: "YYYY-MM",
            }}
            {...props}
        />
    );
};

export { DateRangePicker };
