import { InfoCircleOutlined } from "@ant-design/icons";
import { Popconfirm } from "antd";
import { observer } from "mobx-react";
import { useCallback } from "react";

import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

import type { FC } from "react";

const ProHeadlineButton: FC = observer(() => {
    const { optionStore } = useStores();
    const {
        others: { proUrl, isPro, isConfigProNoticeVisible },
    } = optionStore;
    const href = `${proUrl}&feature=main-button`;

    const handleConfirm = useCallback(() => {
        window.open(href, "_blank");
        optionStore.dismissConfigProNotice();
    }, [optionStore]);

    const handleClose = useCallback(() => {
        optionStore.dismissConfigProNotice();
    }, [optionStore]);

    return (
        !isPro && (
            <Popconfirm
                open={!!isConfigProNoticeVisible}
                title={__(
                    "Thank you for using the free version of Real Cookie Banner. You might also be interested in the PRO version, which offers you more features, 20+ design templates, 160+ service templates, 130+ content blocker templates and much more.",
                )}
                icon={<InfoCircleOutlined style={{ color: "#1890ff" }} />}
                placement="bottom"
                onConfirm={handleConfirm}
                onCancel={handleClose}
                cancelText={__("No, not interested...")}
                okText={__("I want to learn more!")}
                overlayStyle={{ maxWidth: 450 }}
            >
                <a className="page-title-action" rel="noreferrer" onClick={handleConfirm}>
                    {__("Get PRO version")}
                </a>
            </Popconfirm>
        )
    );
});

export { ProHeadlineButton };
