import moment from "moment";
import { useMemo } from "react";

import { __ } from "../utils/i18n.js";

function useAvailableDateRangesForFilter() {
    const availableRanges: Record<string, [moment.Moment, moment.Moment]> = useMemo(
        () => ({
            [__("Today")]: [moment(), moment()],
            [__("This Year")]: [moment().startOf("year"), moment().endOf("year")],
            [__("This Month")]: [moment().startOf("month"), moment().endOf("month")],
            [__("This Week")]: [moment().startOf("week"), moment().endOf("week")],
            [__("Last 30 days")]: [moment().subtract(30, "days"), moment()],
            [__("Last 90 days")]: [moment().subtract(30, "days"), moment()],
        }),
        [],
    );

    return availableRanges;
}

export { useAvailableDateRangesForFilter };
