import { useParams } from "react-router-dom";

import { useRouteCookieGroup } from "./useRouteCookieGroup.js";
import { CookieModel } from "../models/cookieModel.js";

const useRouteCookie = () => {
    const routeGroup = useRouteCookieGroup();
    const { group } = routeGroup;
    const params = useParams();

    // Get cookie or return draft object
    const id = isNaN(+params.cookie) ? 0 : +params.cookie;
    const queried = !!params.cookie;
    const cookie =
        group.cookies.entries.get(+params.cookie) ||
        new CookieModel(group.cookies, {
            id: 0,
        });

    return { routeGroup, cookie, id, queried, fetched: cookie.key !== 0 };
};

export { useRouteCookie };
