import { useCallback } from "react";
import { useParams } from "react-router-dom";

import { CookieGroupModel } from "../models/cookieGroupModel.js";
import { useStores } from "../store/stores.js";

import type { CookieModel } from "../models/cookieModel.js";

const useRouteCookieGroup = () => {
    const { cookieGroup } = useParams();
    const { cookieStore } = useStores();

    // Get cookie group or return draft object
    const id = isNaN(+cookieGroup) ? 0 : +cookieGroup;
    const queried = !!cookieGroup;
    const group = cookieStore.groups.entries.get(id) || new CookieGroupModel(cookieStore.groups, { id: 0 });

    const link = `#/cookies`;
    const editLink = useCallback(({ key }: CookieModel) => `#/cookies/${group.key}/edit/${key}`, [group]);
    const addCookieLink = `#/cookies/${group.key}/new`;

    return { group, id, queried, fetched: group.key !== 0, link, editLink, addCookieLink };
};

export { useRouteCookieGroup };
