import { useMemo } from "react";
import { useLocation, useParams } from "react-router-dom";

/**
 * @see https://stackoverflow.com/a/76343472/5506547
 */
function useRoutePattern() {
    const { pathname } = useLocation();
    const params = useParams();
    return useMemo(
        () =>
            Object.entries(params).reduce((path: any, [key, value]) => path.replace(`/${value}`, `/:${key}`), pathname),
        [pathname],
    );
}

export { useRoutePattern };
