import { useCallback } from "react";
import { useParams } from "react-router-dom";

import { TcfVendorConfigurationModel } from "../models/tcfVendorConfigurationModel.js";
import { useStores } from "../store/stores.js";

const useRouteTcfVendorConfiguration = () => {
    const { tcfStore } = useStores();

    // Get blocker or return draft object
    const vendorConfigurationId = +useParams().vendorConfiguration;
    const id = isNaN(+vendorConfigurationId) ? 0 : +vendorConfigurationId;
    const queried = !!vendorConfigurationId;
    const vendorConfiguration =
        tcfStore.vendorConfigurations.entries.get(id) ||
        new TcfVendorConfigurationModel(tcfStore.vendorConfigurations, { id: 0 });

    const link = `#/cookies/tcf-vendors`;
    const editLink = useCallback(
        ({ key }: TcfVendorConfigurationModel) => `#/cookies/tcf-vendors/edit/${key}`,
        [vendorConfiguration],
    );
    const addLink = `#/cookies/tcf-vendors/new`;

    return { vendorConfiguration, id, queried, fetched: vendorConfiguration.key !== 0, link, editLink, addLink };
};

export { useRouteTcfVendorConfiguration };
