import { action, computed } from "mobx";

import type { WpRestEndpointWithMultilingualSection } from "@devowl-wp/multilingual";
import type { PostStatus } from "@devowl-wp/utils";
import { AbstractPost, ClientModel } from "@devowl-wp/utils";

import { request } from "../utils/request.js";

import type { BannerLinkCollection } from "./bannerLinkCollection.js";
import type { BannerLinkMeta } from "../types/bannerLink.js";

@ClientModel.annotate({
    keyId: "id",
    namespace: "wp/v2",
    request,
    create: {
        path: "/rcb-banner-link",
    },
    patch: {
        path: "/rcb-banner-link/:id",
    },
    delete: {
        path: "/rcb-banner-link/:id",
    },
})
class BannerLinkModel extends AbstractPost<
    BannerLinkCollection,
    BannerLinkMeta,
    WpRestEndpointWithMultilingualSection
> {
    @computed
    public get rootStore() {
        return this.collection.store.rootStore;
    }

    public constructor(collection: BannerLinkModel["collection"], data: Partial<BannerLinkModel["data"]> = {}) {
        super(collection, data);
    }

    @action
    public setOrder(order: number) {
        this.data.menu_order = order;
    }

    @action
    public setLabel(label: string) {
        this.data.title.raw = label;
    }

    @action
    public setStatus(status: PostStatus) {
        this.data.status = status;
    }

    @action
    public setMeta(meta: BannerLinkModel["data"]["meta"]) {
        this.data.meta = meta;
    }

    public transformDataForPatch(): any {
        const data = super.transformDataForPatch();
        return {
            title: data.title,
            content: "",
            status: data.status,
            meta: data.meta,
            menu_order: data.menu_order,
            slug: data.title,
        };
    }
}

export { BannerLinkModel };
