import { computed, flow, observable, runInAction } from "mobx";

import { truncateMiddle } from "@devowl-wp/react-utils";

import type { ScannerStore } from "../store/scanner.js";
import type { ResponseRouteScannerResultAllExternalUrls } from "../wp-api/scannerResultsAllExternalUrls.get.js";

class ScannerResultExternalUrlSingle {
    @observable
    public busy = false;

    @observable
    public data: ResponseRouteScannerResultAllExternalUrls["items"][0];

    @computed
    public get markup() {
        return this.store.resultMarkup.get(this.data.id);
    }

    @computed
    public get blockedUrlTruncate() {
        return truncateMiddle(this.data.blockedUrl, 50, "[...]");
    }

    @computed
    public get sourceUrlTruncate() {
        return truncateMiddle(this.data.sourceUrl, 50, "[...]");
    }

    public readonly store: ScannerStore;

    public constructor(template: ScannerResultExternalUrlSingle["data"], store: ScannerStore) {
        runInAction(() => {
            this.data = template;
        });
        this.store = store;
    }

    public fetchMarkup: () => Promise<void> = flow(function* (this: ScannerResultExternalUrlSingle) {
        yield this.store.fetchMarkup(this.data.id);
    });
}

export { ScannerResultExternalUrlSingle };
