import { observable, runInAction } from "mobx";

import type { TcfStore } from "../store/tcf.js";
import type { ResponseRouteTcfDeclarationsGet } from "../wp-api/tcfDeclarations.get.js";

class TcfDataCategory {
    @observable
    public data: ResponseRouteTcfDeclarationsGet["dataCategories"][0];

    public readonly store: TcfStore;

    public constructor(data: TcfDataCategory["data"], store: TcfStore) {
        runInAction(() => {
            this.data = data;
        });
        this.store = store;
    }
}

export { TcfDataCategory };
