import { observable, runInAction } from "mobx";

import type { TcfStore } from "../store/tcf.js";
import type { ResponseRouteTcfDeclarationsGet } from "../wp-api/tcfDeclarations.get.js";

class TcfFeature {
    @observable
    public data: ResponseRouteTcfDeclarationsGet["features"][0];

    @observable
    public special: boolean;

    public readonly store: TcfStore;

    public constructor(data: TcfFeature["data"], special: boolean, store: TcfStore) {
        runInAction(() => {
            this.special = special;
            this.data = data;
        });
        this.store = store;
    }
}

export { TcfFeature };
