import { observable, runInAction } from "mobx";

import type { TcfStore } from "../store/tcf.js";
import type { ResponseRouteTcfDeclarationsGet } from "../wp-api/tcfDeclarations.get.js";

class TcfPurpose {
    @observable
    public data: ResponseRouteTcfDeclarationsGet["purposes"][0];

    @observable
    public special: boolean;

    public readonly store: TcfStore;

    public constructor(data: TcfPurpose["data"], special: boolean, store: TcfStore) {
        runInAction(() => {
            this.special = special;
            this.data = data;
        });
        this.store = store;
    }
}

export { TcfPurpose };
