import { AbstractPostCollection, ClientCollection, RouteHttpVerb } from "@devowl-wp/utils";

import { TcfVendorConfigurationModel } from "./tcfVendorConfigurationModel.js";
import { request } from "../utils/request.js";

import type { TcfStore } from "../store/tcf.js";

@ClientCollection.annotate({
    path: "/rcb-tcf-vendor-conf",
    singlePath: "/rcb-tcf-vendor-conf/:id",
    namespace: "wp/v2",
    methods: [RouteHttpVerb.GET],
    request,
})
class TcfVendorConfigurationCollection extends AbstractPostCollection<TcfVendorConfigurationModel> {
    public readonly store: TcfStore;

    public constructor(store: TcfStore) {
        super();
        this.store = store;
    }

    public instance(response: TcfVendorConfigurationModel["data"]): TcfVendorConfigurationModel {
        return new TcfVendorConfigurationModel(this).fromResponse(response);
    }
}

export { TcfVendorConfigurationCollection };
