import { createRoot } from "react-dom/client";

import { getSidebarCustomize } from "@devowl-wp/customize";
import type { UpsellFeature } from "@devowl-wp/react-cookie-banner-admin";
import { UpsellTag } from "@devowl-wp/react-cookie-banner-admin";

import { CustomizeContextProvider } from "../components/customize/contextProvider.js";

/**
 * Add an "Unlock" tag to a given customize label id.
 */
function applyCustomizeProTag(controlId: string, feature: UpsellFeature) {
    const customize = getSidebarCustomize();
    customize.control(controlId, () => {
        const element = document.querySelector(`label[for="_customize-input-${controlId}"]`);
        const span = document.createElement("span");
        element.appendChild(span);

        createRoot(span).render(
            <CustomizeContextProvider>
                <UpsellTag {...feature} wrapperAttributes={{ style: { marginLeft: 5 } }} />
            </CustomizeContextProvider>,
        );
    });
}

export { applyCustomizeProTag };
