import { commonRequest } from "@devowl-wp/utils";

import { getOptionsFromWindow } from "../utils/getOptionsFromWindow.js";
import { locationRestConsentClearDelete } from "../wp-api/consentClear.delete.js";

import type {
    ParamsRouteConsentClearDelete,
    RequestRouteConsentClearDelete,
    ResponseRouteConsentClearDelete,
} from "../wp-api/consentClear.delete.js";

/**
 * Delete cookies on server side (currently only `http`).
 */
function deleteCookiesServer(cookies: number[]) {
    const { restNamespace, restRoot, restQuery, restNonce, restPathObfuscateOffset } = getOptionsFromWindow();
    commonRequest<RequestRouteConsentClearDelete, ParamsRouteConsentClearDelete, ResponseRouteConsentClearDelete>({
        location: locationRestConsentClearDelete,
        options: {
            restNamespace,
            restRoot,
            restQuery,
            restNonce,
            restPathObfuscateOffset,
        },
        sendRestNonce: false,
        params: {
            cookies: cookies.join(","),
        },
    });
}

export { deleteCookiesServer };
