import type { FormSettingsValueProps } from "@devowl-wp/react-cookie-banner-admin";

/**
 * This type is using all available meta fields coming from the WordPress REST API. `label` is not part of it,
 * as we are using `post_title` for this.
 */
type BannerLinkMeta = Omit<FormSettingsValueProps["navLinks"][0], "label">;

type BannerLinkDefinition = BannerLinkMeta & {
    id: number;
    label: string;
};

export { type BannerLinkMeta, type BannerLinkDefinition };
