import type { VisualThumbnail } from "@devowl-wp/headless-content-unblocker";
import type { VisualBlocker } from "@devowl-wp/react-cookie-banner";

/**
 * This type is using all available meta fields coming from the WordPress REST API. `name` and
 * `description` is not part of it, as we are using `post_content` and `post_title` for this.
 */
type BlockerMeta = Omit<VisualBlocker, "id" | "name" | "description" | "visualThumbnail" | "services"> & {
    presetVersion?: number;
    criteria: "services" | "tcfVendors";
    tcfVendors: string;
    tcfPurposes: string;
    services: string;
    rules: string;
    isVisual: boolean;
    visualMediaThumbnail?: number; // This field is only available via REST API
    visualDownloadThumbnail: boolean;
    shouldForceToShowVisual: boolean;
};

type BlockerDefinition = Omit<BlockerMeta, "tcfVendors" | "tcfPurposes" | "services" | "rules"> & {
    id: number;
    name: string;
    description: string;
    tcfVendors: number[];
    tcfPurposes: number[];
    services: number[];
    rules: string[];
    // This field is only calculated on WordPress website frontend
    visualThumbnail?: VisualThumbnail;
};

export { type BlockerMeta, type BlockerDefinition };
