import type { ServiceGroup } from "@devowl-wp/cookie-consent-web-client";
import type { VisualService } from "@devowl-wp/react-cookie-banner";

type CookieGroupDefinition = Omit<ServiceGroup, "items"> & {
    name: string;
    description: string;
    items: CookieDefinition[];
};

/**
 * This type is using all available meta fields coming from the WordPress REST API. `name` and
 * `purpose` is not part of it, as we are using `post_content` and `post_title` for this.
 */
type CookieMeta = Omit<
    VisualService,
    | "id"
    | "technicalDefinitions"
    | "codeDynamics"
    | "name"
    | "purpose"
    | "dataProcessingInCountries"
    | "dataProcessingInCountriesSpecialTreatments"
    | "providerContact"
    | "googleConsentModeConsentTypes"
> & {
    presetVersion?: number;
    // Split into multiple first-level fields instead of an object so it is compatible with WPML's translation system
    providerContactPhone: VisualService["providerContact"]["phone"];
    providerContactEmail: VisualService["providerContact"]["email"];
    providerContactLink: VisualService["providerContact"]["link"];

    technicalDefinitions: string; // saved as JSON string in WordPress meta
    dataProcessingInCountries: string; // saved as JSON string in WordPress meta
    dataProcessingInCountriesSpecialTreatments: string; // saved as JSON string in WordPress meta
    codeDynamics: string; // saved as JSON string in WordPress meta
    googleConsentModeConsentTypes: string; // saved as JSON string in WordPress meta
};

type CookieDefinition = VisualService;

export { type CookieGroupDefinition, type CookieMeta, type CookieDefinition };
