import type { CustomizeIds } from "@devowl-wp/customize";

type CustomizeIdsBanner = CustomizeIds<
    {
        bodyDesignTeachings: string;
        bodyDesignTeachingsFont: string;
        bodyDesignTeachingsSeparator: string;
        bodyDesignAccordion: string;
        bodyDesignAccordionBorder: string;
        bodyDesignAccordionTitle: string;
        bodyDesignAccordionDescription: string;
        bodyDesignAcceptAll: string;
        bodyDesignAcceptAllFont: string;
        bodyDesignAcceptAllBorder: string;
        bodyDesignAcceptAllHover: string;
        bodyDesignAcceptEssentials: string;
        bodyDesignAcceptEssentialsFont: string;
        bodyDesignAcceptEssentialsBorder: string;
        bodyDesignAcceptEssentialsHover: string;
        bodyDesignAcceptIndividual: string;
        bodyDesignAcceptIndividualFont: string;
        bodyDesignAcceptIndividualBorder: string;
        bodyDesignAcceptIndividualHover: string;
        textsTcfStacks: string;
        textsSticky: string;
        saveButtonFont: string;
        saveButtonBorder: string;
        saveButtonHover: string;
        footerLanguageSwitcher: string;
        stickyIcon: string;
        stickyBorder: string;
        stickyBoxShadow: string;
        stickyHover: string;
        stickyMenu: string;
    },
    {
        customHtmlDecisionButtonTypeDiffers: string;
        customHtmlDecisionLegalNoticeAll: string;
        customHtmlDecisionLegalNoticeEssentials: string;
        customHtmlDecisionLegalNoticeIndividual: string;
        customHtmlMobileHideHeaderIgnoreDueCloseIcon: string;
        customHtmlLayoutMaxHeightNotice: string;
        customHtmlLayoutAnimationInClsNotice: string;
    },
    {
        layout: string;
        colors: string;
        decision: string;
        design: string;
        headerDesign: string;
        footerDesign: string;
        texts: string;
        individualLayout: string;
        group: string;
        saveButton: string;
        individualTexts: string;
        customCss: string;
        mobile: string;
        sticky: string;
        cookiePolicy: string;
    },
    {
        layout: {
            type: string;
            maxHeightEnabled: string;
            maxHeight: string;
            dialogMaxWidth: string;
            dialogPosition: string;
            dialogMargin: string;
            bannerPosition: string;
            bannerMaxWidth: string;
            overlay: string;
            overlayBg: string;
            overlayBgAlpha: string;
            overlayBlur: string;
            animationIn: string;
            animationInDuration: string;
            animationInOnlyMobile: string;
            animationOut: string;
            animationOutDuration: string;
            animationOutOnlyMobile: string;
            dialogBorderRadius: string;
            borderRadius: string;
        };
        decision: {
            acceptAll: string;
            acceptEssentials: string;
            showCloseIcon: string;
            acceptIndividual: string;
            showGroups: string;
            groupsFirstView: string;
            saveButton: string;
            buttonOrder: string;
        };
        design: {
            bg: string;
            borderWidth: string;
            borderColor: string;
            textAlign: string;
            linkTextDecoration: string;
            fontSize: string;
            fontColor: string;
            fontInheritFamily: string;
            fontFamily: string;
            fontWeight: string;
            boxShadowEnabled: string;
            boxShadowOffsetX: string;
            boxShadowOffsetY: string;
            boxShadowBlurRadius: string;
            boxShadowSpreadRadius: string;
            boxShadowColor: string;
            boxShadowColorAlpha: string;
        };
        headerDesign: {
            inheritBg: string;
            bg: string;
            inheritTextAlign: string;
            textAlign: string;
            padding: string;
            logo: string;
            logoRetina: string;
            logoMaxHeight: string;
            logoPosition: string;
            logoMargin: string;
            fontSize: string;
            fontColor: string;
            fontInheritFamily: string;
            fontFamily: string;
            fontWeight: string;
            borderWidth: string;
            borderColor: string;
        };
        bodyDesign: {
            padding: string;
            descriptionInheritFontSize: string;
            descriptionFontSize: string;
            dottedGroupsInheritFontSize: string;
            dottedGroupsFontSize: string;
            dottedGroupsBulletColor: string;
            teachingsInheritFontSize: string;
            teachingsFontSize: string;
            teachingsInheritFontColor: string;
            teachingsFontColor: string;
            teachingsInheritTextAlign: string;
            teachingsTextAlign: string;
            teachingsSeparatorActive: string;
            teachingsSeparatorWidth: string;
            teachingsSeparatorHeight: string;
            teachingsSeparatorColor: string;
            accordionMargin: string;
            accordionPadding: string;
            accordionArrowType: string;
            accordionArrowColor: string;
            accordionBg: string;
            accordionActiveBg: string;
            accordionHoverBg: string;
            accordionBorderWidth: string;
            accordionBorderColor: string;
            accordionTitleFontSize: string;
            accordionTitleFontColor: string;
            accordionTitleFontWeight: string;
            accordionDescriptionMargin: string;
            accordionDescriptionFontSize: string;
            accordionDescriptionFontColor: string;
            accordionDescriptionFontWeight: string;
            acceptAllOneRowLayout: string;
            acceptAllFontSize: string;
            acceptAllPadding: string;
            acceptAllBg: string;
            acceptAllTextAlign: string;
            acceptAllBorderWidth: string;
            acceptAllBorderColor: string;
            acceptAllFontColor: string;
            acceptAllFontWeight: string;
            acceptAllHoverBg: string;
            acceptAllHoverFontColor: string;
            acceptAllHoverBorderColor: string;
            acceptEssentialsUseAcceptAll: string;
            acceptEssentialsButtonType: string;
            acceptEssentialsFontSize: string;
            acceptEssentialsFontWeight: string;
            acceptEssentialsPadding: string;
            acceptEssentialsBg: string;
            acceptEssentialsTextAlign: string;
            acceptEssentialsBorderWidth: string;
            acceptEssentialsBorderColor: string;
            acceptEssentialsFontColor: string;
            acceptEssentialsHoverBg: string;
            acceptEssentialsHoverFontColor: string;
            acceptEssentialsHoverBorderColor: string;
            acceptIndividualFontSize: string;
            acceptIndividualFontWeight: string;
            acceptIndividualPadding: string;
            acceptIndividualBg: string;
            acceptIndividualTextAlign: string;
            acceptIndividualBorderWidth: string;
            acceptIndividualBorderColor: string;
            acceptIndividualFontColor: string;
            acceptIndividualHoverBg: string;
            acceptIndividualHoverFontColor: string;
            acceptIndividualHoverBorderColor: string;
        };
        footerDesign: {
            poweredByLink: string;
            inheritBg: string;
            bg: string;
            inheritTextAlign: string;
            textAlign: string;
            padding: string;
            fontSize: string;
            fontColor: string;
            fontInheritFamily: string;
            fontFamily: string;
            fontWeight: string;
            hoverFontColor: string;
            borderWidth: string;
            borderColor: string;
            languageSwitcher: string;
        };
        texts: {
            headline: string;
            description: string;
            acceptAll: string;
            acceptEssentials: string;
            acceptIndividual: string;
            dataProcessingInUnsafeCountries: string;
            tcfStacksCustomName: string;
            tcfStacksCustomDescription: string;
            ageNoticeBanner: string;
            listServicesNotice: string;
            ageNoticeBlocker: string;
            consentForwardingExternalHosts: string;
            poweredBy: string;
            blockerHeadline: string;
            blockerLinkShowMissing: string;
            blockerLoadButton: string;
            blockerAcceptInfo: string;
            stickyChange: string;
            stickyHistory: string;
            stickyRevoke: string;
            stickyRevokeSuccessMessage: string;
        };
        individualLayout: {
            inheritDialogMaxWidth: string;
            dialogMaxWidth: string;
            inheritBannerMaxWidth: string;
            bannerMaxWidth: string;
            descriptionTextAlign: string;
        };
        group: {
            checkboxBg: string;
            checkboxBorderWidth: string;
            checkboxBorderColor: string;
            checkboxActiveColor: string;
            checkboxActiveBg: string;
            checkboxActiveBorderColor: string;
            groupInheritBg: string;
            groupBg: string;
            groupPadding: string;
            groupSpacing: string;
            groupBorderRadius: string;
            groupBorderWidth: string;
            groupBorderColor: string;
            headlineFontSize: string;
            headlineFontColor: string;
            headlineFontWeight: string;
            descriptionFontSize: string;
            descriptionFontColor: string;
            linkColor: string;
            linkHoverColor: string;
            detailsHideLessRelevant: string;
        };
        saveButton: {
            useAcceptAll: string;
            type: string;
            fontSize: string;
            padding: string;
            bg: string;
            textAlign: string;
            borderWidth: string;
            borderColor: string;
            fontColor: string;
            fontWeight: string;
            hoverBg: string;
            hoverFontColor: string;
            hoverBorderColor: string;
        };
        individualTexts: {
            headline: string;
            description: string;
            save: string;
            showMore: string;
            hideMore: string;
            postamble: string;
        };
        customCss: {
            antiAdBlocker: string;
            css: string;
        };
        mobile: {
            enabled: string;
            maxHeight: string;
            hideHeader: string;
            alignment: string;
            scalePercent: string;
            scalePercentVertical: string;
        };
        sticky: {
            enabled: string;
            animationsEnabled: string;
            alignment: string;
            bubbleBorderRadius: string;
            bubbleMargin: string;
            bubblePadding: string;
            bubbleBg: string;
            bubbleBorderWidth: string;
            bubbleBorderColor: string;
            icon: string;
            iconCustom: string;
            iconCustomRetina: string;
            iconSize: string;
            iconColor: string;
            boxShadowEnabled: string;
            boxShadowOffsetX: string;
            boxShadowOffsetY: string;
            boxShadowBlurRadius: string;
            boxShadowSpreadRadius: string;
            boxShadowColor: string;
            boxShadowColorAlpha: string;
            bubbleHoverBg: string;
            bubbleHoverBorderColor: string;
            hoverIconColor: string;
            hoverIconCustom: string;
            hoverIconCustomRetina: string;
            menuFontSize: string;
            menuBorderRadius: string;
            menuItemSpacing: string;
            menuItemPadding: string;
        };
        cookiePolicy: {
            instruction: string;
            headlineToc: string;
            headlineControllerOfWebsite: string;
            headlineDiffToPrivacyPolicy: string;
            headlineCookieTechnology: string;
            headlineLegalBasis: string;
            headlineRightsOfTheVisitor: string;
            headlineManageCookies: string;
            headlineCookieOrigin: string;
            headlineListOfServices: string;
            diffToPrivacyPolicy: string;
            cookieTechnology: string;
            legalBasisGdpr: string;
            legalBasisDsg: string;
            rightsOfTheVisitor: string;
            manageCookies: string;
            cookieOrigin: string;
            additionalContent: string;
        };
    }
>;

export { type CustomizeIdsBanner };
