import type { Frontend } from "@devowl-wp/cookie-consent-management";
import type { FreemiumOptions } from "@devowl-wp/freemium";
import type { findVisualParent } from "@devowl-wp/headless-content-unblocker";
import type { BannerContext, CommonContextProps, Customize } from "@devowl-wp/react-cookie-banner";
import type { FormSettingsContext, UpsellContext, UpsellModalHintProps } from "@devowl-wp/react-cookie-banner-admin";

import type { CustomizeIdsBanner } from "./customizeIdsBanner.js";

type OtherOptions = {
    frontend: Frontend;
    anonymousHash?: string;
    anonymousContentUrl?: string;
    hasDynamicPreDecisions: boolean;
    installationDateIso: string;
    isLicensed: boolean;
    isDevLicense: boolean;
    assetsUrl?: string;
    isPreventPreDecision: boolean;
    isInvalidateImplicitUserConsent: boolean;
    isCurrentlyInTranslationEditorPreview: boolean;
    customizeBannerUrl?: string;
    adminUrl?: string;
    customizeIdsBanner?: CustomizeIdsBanner;
    customizeValuesBanner?: Customize;
    customizeDefaultsBanner?: Customize;
    colorScheme?: string[];
    pageRequestUuid4: string;
    defaultCookieGroupTexts?: Record<string, string>;
    useEncodedStringForScriptInputs?: boolean;
    resetUrl?: string;
    resetTexts?: {
        dry: FormSettingsContext["contextValue"]["resetTextsLanguages"];
        url: string;
    };
    pageByIdUrl: string;
    visualParentSelectors: Parameters<typeof findVisualParent>[1];
    dependantVisibilityContainers: string[];
    disableDeduplicateExceptions?: string[];
    poweredByTexts?: string[];
    isPoweredByLinkDisabledByException?: boolean;
    bannerDesignVersion: CommonContextProps["designVersion"];
    bannerI18n: BannerContext["contextValue"]["i18n"] & {
        crawlerLinkAlert: string;
        none: string;
        noLicense: string;
        devLicense: string;
        devLicenseLearnMore: string;
        devLicenseLink: string;
    };
    pluginUrl: string;
    cachePlugins?: {
        [slug: string]: string;
    };
    hints?: {
        deleteCookieGroup: string[];
        deleteCookie: string[];
        export: string[];
        dashboardTile: Array<{
            logo?: string;
            title: string;
            description?: string;
            links?: Array<{
                link: string;
                linkText: string;
            }>;
        }>;
        proDialog?: UpsellModalHintProps;
    };
    modalHints?: string[];
    isDemoEnv?: boolean;
    isConfigProNoticeVisible?: boolean;
    activePlugins?: Record<string, string>;
    iso3166OneAlpha2: FormSettingsContext["contextValue"]["iso3166OneAlpha2"];
    ageNoticeCountryAgeMap?: FormSettingsContext["contextValue"]["ageNoticeCountryAgeMap"];
    predefinedCountryBypassLists?: FormSettingsContext["contextValue"]["predefinedCountryBypassLists"];
    multilingualSkipHTMLForTag: string;
    defaultLanguage: string;
    currentLanguage: string;
    activeLanguages: string[];
    context: string;
    showNoticeAnonymousScriptNotWritable?: boolean;
    originalHomeUrl?: string;
    showLicenseFormImmediate?: boolean;
    // This object is only available in PRO version and if a link is given
    affiliate?: CommonContextProps["affiliate"];
    capabilities?: Record<string, boolean>;
    /**
     * Only available in PRO version and only on pages where the current revision is not available.
     */
    fomoCoupon?: UpsellContext["contextValue"]["fomoCoupon"];
} & FreemiumOptions;

export { type OtherOptions };
