const SCAN_QUEUE_JOB = "rcb-scan";
const AUTOMATIC_SCAN_STATER_QUEUE_JOB = "rcb-automatic-scan-starter";
const DATABASE_CONSENT_MIGRATION_QUEUE_JOB = "rcb-db-consent-v2";

type ScanQueueJobData = {
    url: string;
    isLoopback: boolean;
    allowFailure: boolean;
};

type AutomaticScanStarterQueueJobData = Record<string, never>;

type DatabaseConsentMigrationV2QueueJobData = {
    maxId: number;
    minId: number;
    process: {
        consent: {
            consent: number;
        };
        decisions: {
            previous_decision: number;
            decision: number;
            previous_gcm_consent: number;
            gcm_consent: number;
        };
        ip: {
            ip: number;
        };
        tcf_string: {
            previous_tcf_string: number;
            tcf_string: number;
        };
        urls: {
            url_imprint: number;
            url_privacy_policy: number;
            referer: number;
            pure_referer: number;
        };
    };
    results: DatabaseConsentMigrationV2QueueJobData["process"];
};

export {
    type ScanQueueJobData,
    type AutomaticScanStarterQueueJobData,
    type DatabaseConsentMigrationV2QueueJobData,
    SCAN_QUEUE_JOB,
    AUTOMATIC_SCAN_STATER_QUEUE_JOB,
    DATABASE_CONSENT_MIGRATION_QUEUE_JOB,
};
