import type { BaseOptions } from "@devowl-wp/utils";
import { getAnonymousLocalizedScript } from "@devowl-wp/utils";

import type { OtherOptions } from "../types/otherOptions.js";

/**
 * Use this if you do not have the Mobx store available in your JavaScript asset.
 * E. g. the `banner.js` does not rely on the mobx store and should access the
 * localized options via `window.realCookieBanner` directly.
 */
function getOptionsFromWindow(): {
    others: OtherOptions;
    restNamespace: string;
    restPathObfuscateOffset: string;
    restRoot: string;
    restNonce: string;
    restQuery: any;
    version: string;
} & Pick<BaseOptions, "publicUrl" | "chunkFolder"> {
    return getAnonymousLocalizedScript(process.env.slug, {
        makeBase64Encoded: ["codeOptIn", "codeOptOut", "codeOnPageLoad", "contactEmail"],
        lazyParse: (obj, parseLazy) => {
            parseLazy(obj.others, "frontend", "groups");
            parseLazy(obj.others, "frontend", "tcf");
            parseLazy(obj, "others", "customizeValuesBanner");
        },
    });
}

export { getOptionsFromWindow };
