import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestChecklistGet: RouteLocationInterface = {
    path: "/checklist",
    method: RouteHttpVerb.GET,
};

interface RequestRouteChecklistGet extends RouteRequestInterface {}

interface ParamsRouteChecklistGet extends RouteParamsInterface {}

interface ResponseRouteChecklistGetEntity {
    title: string;
    description: string;
    checked: boolean;
    link: string;
    linkText: string;
    linkTarget: string;
    needsPro: boolean;
}

interface ResponseRouteChecklistGet extends RouteResponseInterface {
    dismissed: boolean;
    overdue: boolean;
    items: {
        [key: string]: ResponseRouteChecklistGetEntity;
    };
}

export {
    locationRestChecklistGet,
    type RequestRouteChecklistGet,
    type ParamsRouteChecklistGet,
    type ResponseRouteChecklistGetEntity,
    type ResponseRouteChecklistGet,
};
